/* Revision Control

$Header: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\abstrctr\\abstrcto\\arucrdtg.cpp,v 1.3 2002-08-29 12:04:03+02 renz Exp $ 

$Id: arucrdtg.cpp,v 1.3 2002-08-29 12:04:03+02 renz Exp $ 

$Log: arucrdtg.cpp,v $
Revision 1.3  2002-08-29 12:04:03+02  renz
Added RCS Headers
 

$Author: renz $ 

$Date: 2002-08-29 12:04:03+02 $ 

$Locker:  $ 

$Revision: 1.3 $ 

$Name:  $ 

$RCSfile: arucrdtg.cpp,v $ 

$Source: C:\\RCS\\d\\saldvl\\noteview\\scorevc\\abstrctr\\abstrcto\\arucrdtg.cpp,v $ 

*/
#include "AbstrctR\AbstrctO\ARUCrdTg.h"
#include "AbstrctR\AbstrctO\TgprmtrS.h"
#include "AbstrctR\AbstrctO\TgprmtrN.h"

ListOfTPLs ARUserChordTag::ltpls(1);

ARUserChordTag::ARUserChordTag(const ARUserChordTag *uct)
{
	labels = NULL;
	labeli = NULL;
	labelistr = NULL;

	if (uct->labels)
		labels = dynamic_cast<TagParameterString *>
		(uct->labels->getCopy());
	else if (uct->labeli)
	{
		labeli = dynamic_cast<TagParameterInt *>
		(uct->labeli->getCopy());

		if (uct->labelistr)
		{
			labelistr = new NVstring(*uct->labelistr);
		}
		else
		{
			labelistr = new NVstring("intlabel");
			char buf[100];
			itoa(labeli->getValue(),buf,10);
			labelistr->append(buf);
		}
	}
}

ARUserChordTag::~ARUserChordTag()
	{
	if (labels)
		delete labels;
	if (labeli)
		delete labeli;
	if (labelistr)
		delete labelistr;
	}

ARMusicalObject *ARUserChordTag::Copy() const
{
	return new ARUserChordTag(this);
}

const NVstring & ARUserChordTag::getLabelValue() const
{
	if (labels)
	{
		return labels->getValue();
	}
	else if (labeli && labelistr)
	{
		return *labelistr;
	}
	return NVstring::emptyString;
}
void ARUserChordTag::setTagParameterList(TagParameterList& tpl)
{
	if (ltpls.GetCount() == 0)
	{
		// create a list of string ...

		ListOfStrings lstrs(1);
		lstrs.AddTail(
			new NVstring(
			"S,label,,o"));
		lstrs.AddTail(
			new NVstring(
			"I,label,,o"));
		CreateListOfTPLs(ltpls,lstrs);
	}

	TagParameterList *rtpl = NULL;
	int ret = MatchListOfTPLsWithTPL(ltpls,tpl,&rtpl);

	if (ret>=0 && rtpl)
	{
		// we found a match!
		if (ret == 0)
		{
			// then, we now the match for
			// the first ParameterList
			// POSITION pos = rtpl->GetHeadPosition();

			labels = dynamic_cast<TagParameterString *>
				(rtpl->RemoveHead());
		}
		else if (ret == 1)
		{
			labeli = dynamic_cast<TagParameterInt *>
				(rtpl->RemoveHead());
			labelistr = new NVstring("intlabel");
			char buf[100];
			itoa(labeli->getValue(),buf,10);
			labelistr->append(buf);
		}

		delete rtpl;
	}
		
	
	tpl.RemoveAll();
}

void ARUserChordTag::PrintParameters(ostream &os) const
{
	if (labels && labels->TagIsSet())
		{
			os << "<label=\"" << 
				labels->getValue() << "\">";
		}
	else if (labeli && labeli->TagIsSet())
	{
		os << "<label=" << labeli->getValue() << ">";
	}
}

